﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>

	

	<xsl:strip-space elements="*"/>



	<xsl:template match='//debugProperties/breakpoints'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="name">breakpoints</xsl:with-param>

			<!--<xsl:with-param name="nohandler">false</xsl:with-param>-->

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template match='/Variables'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="name">variables</xsl:with-param>

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>



	<xsl:template match='callstack'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="name">callstack</xsl:with-param>

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>



	<xsl:template match='/Watch'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="name">watchs</xsl:with-param>

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="sheet"/>

		<xsl:param name="hidden"/>

		<xsl:if test='$sheet[.="breakpoints"]'>

			<xsl:call-template name="breakpoint_columns_def">

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet="variables"'>

			<xsl:call-template name="variables_columns_def">

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet[.="callstack"]'>

			<xsl:call-template name="callstack_columns_def">

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet[.="watchs"]'>

			<xsl:call-template name="watchs_columns_def">

				<xsl:with-param name="hidden" select="$hidden"/>

			</xsl:call-template>

		</xsl:if>

	</xsl:template>



	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:param name="sheet"/>

		<xsl:if test='$sheet[.="breakpoints"]'>

			<xsl:for-each select="breakpoint">

				<xsl:call-template name="spreadsheet_row">

					<xsl:with-param name="hidden" select="$hidden"/>

					<xsl:with-param name="sheet" select="$sheet"/>

				</xsl:call-template>

			</xsl:for-each>

		</xsl:if>

		<xsl:if test='$sheet[.="callstack"]'>

			<xsl:for-each select="stackitem">

				<xsl:call-template name="spreadsheet_row">

					<xsl:with-param name="hidden" select="$hidden"/>

					<xsl:with-param name="sheet" select="$sheet"/>

				</xsl:call-template>

			</xsl:for-each>

		</xsl:if>

		<xsl:if test='$sheet[.="watchs"]'>

			<xsl:for-each select="Watch">

				<xsl:call-template name="spreadsheet_row">

					<xsl:with-param name="hidden" select="$hidden"/>

					<xsl:with-param name="sheet" select="$sheet"/>

					<xsl:with-param name="hasChild" select="string(@expandNode)"/>

					<xsl:with-param name="expanded" select='(@expandNode="expand")'/>

				</xsl:call-template>

			</xsl:for-each>

			<xsl:call-template name="spreadsheet_row">

				<xsl:with-param name="hidden" select="$hidden"/>

				<xsl:with-param name="sheet" select="$sheet"/>

			</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet="variables"'>

			<xsl:for-each select="Variables">

				<xsl:call-template name="spreadsheet_row">

					<xsl:with-param name="hidden" select="$hidden"/>

					<xsl:with-param name="sheet" select="$sheet"/>

					<xsl:with-param name="hasChild" select="string(@expandNode)"/>

					<xsl:with-param name="expanded" select='(@expandNode="expand")'/>

				</xsl:call-template>

			</xsl:for-each>

		</xsl:if>

	</xsl:template>



	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="sheet"/>

		<xsl:param name="hasChild"/>

		<xsl:param name="expanded"/>

		<xsl:if test='$sheet[.="breakpoints"]'>

			<xsl:call-template name="breakpoint_values_def"/>

		</xsl:if>

		<xsl:if test='$sheet[.="callstack"]'>

			<xsl:call-template name="callstack_values_def"/>

		</xsl:if>

		<xsl:if test='$sheet[.="watchs"]'>

			<xsl:call-template name="watchs_values_def">

			<xsl:with-param name="hasChild" select="$hasChild"/>

			<xsl:with-param name="expanded" select="$expanded"/>

		</xsl:call-template>

		</xsl:if>

		<xsl:if test='$sheet[.="variables"]'>

			<xsl:call-template name="variables_values_def">

				<xsl:with-param name="hasChild" select="$hasChild"/>

				<xsl:with-param name="expanded" select="$expanded"/>

			</xsl:call-template>

		</xsl:if>

	</xsl:template>



	<xsl:template name="breakpoint_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">&#160;</xsl:with-param>

			<xsl:with-param name="width">40px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Defination</xsl:with-param>

			<xsl:with-param name="width">100%</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Hit Count</xsl:with-param>

			<xsl:with-param name="width">140px</xsl:with-param>

			<xsl:with-param name="type">number</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Condition</xsl:with-param>

			<xsl:with-param name="width">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="variables_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Name</xsl:with-param>

			<xsl:with-param name="width">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Value</xsl:with-param>

			<xsl:with-param name="width">100%</xsl:with-param>

			<xsl:with-param name="minwidth">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Type</xsl:with-param>

			<xsl:with-param name="width">80px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="breakpoint_values_def">

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<input class="spreadsheetCheckbox" type="checkbox" id="{@id}" name="spreadsheetEditor" name2="enable">

					<xsl:if test="@enable='true' or @enable='1'">

						<xsl:attribute name="checked">true</xsl:attribute>

					</xsl:if>

				</input>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<a class='titoAnchor' stmtid="{@stmtid}" url="{@url}" linenumber='{@linenumber}' href='javascript:'>

					<xsl:value-of select="concat(@url, ', ', @linenumber)"/>

				</a>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<input type="text" value="{@hitcount}" id="{@id}" name="spreadsheetEditor" name2="hitcount">

					<xsl:attribute name='class'>variableValue<xsl:if test='@changed = "true"'> variableChanged</xsl:if></xsl:attribute>

				</input>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<input type="text" value="{@condition}" id="{@id}" name="spreadsheetEditor" name2="condition">

					<xsl:attribute name='class'>variableValue<xsl:if test='@changed = "true"'> variableChanged</xsl:if></xsl:attribute>

				</input>

			</xsl:with-param>

		</xsl:call-template>

	</xsl:template>



	<xsl:template name="variables_values_def">

		<xsl:param name="hasChild"/>

		<xsl:param name="expanded"/>

		<xsl:attribute name="variableid"><xsl:value-of select='@id'/></xsl:attribute>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="handleIndent">yes</xsl:with-param>

			<xsl:with-param name="parentList" select='ancestor::*[parent::*]'/>

			<xsl:with-param name="hasChild" select="$hasChild"/>

			<xsl:with-param name="expanded" select="$expanded"/>

			<xsl:with-param name="value" select="string(@name)"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<input value="{@value}"><xsl:attribute name='class'>variableValue<xsl:if test='@changed = "true"'> variableChanged</xsl:if></xsl:attribute><xsl:if test='@editable=false'><xsl:attribute name='readonly'/></xsl:if></input>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@type)"/>

		</xsl:call-template>

	</xsl:template>



	<xsl:template name="callstack_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Source</xsl:with-param>

			<xsl:with-param name="width">60%</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Function</xsl:with-param>

			<xsl:with-param name="width">40%</xsl:with-param>

			<xsl:with-param name="type">number</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Line</xsl:with-param>

			<xsl:with-param name="width">50px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="callstack_values_def">

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value">

				<a class='titoAnchor' id="spreadsheetLink" func="{@func}" url="{@src}" line="{@line}" href='javascript:'>

					<xsl:value-of select="concat(@src, ', ', @line)"/>

				</a>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@func)"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="number(@line)"/>

		</xsl:call-template>

	</xsl:template>



	<xsl:template name="watchs_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Name</xsl:with-param>

			<xsl:with-param name="width">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Value</xsl:with-param>

			<xsl:with-param name="width">100%</xsl:with-param>

			<xsl:with-param name="minwidth">140px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Type</xsl:with-param>

			<xsl:with-param name="width">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

			<xsl:with-param name="fixedPos">true</xsl:with-param>

			<xsl:with-param name="sortable">false</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="watchs_values_def">

		<xsl:param name="hasChild"/>

		<xsl:param name="expanded"/>

		<xsl:attribute name="variableid"><xsl:value-of select='@id'/></xsl:attribute>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="handleIndent">yes</xsl:with-param>

			<xsl:with-param name="parentList" select='ancestor::*[parent::*]'/>

			<xsl:with-param name="hasChild" select="$hasChild"/>

			<xsl:with-param name="expanded" select="$expanded"/>

			<xsl:with-param name="value">

				<xsl:choose><xsl:when test='parent::Watch/parent::Watch'><xsl:value-of select="string(@name)"/></xsl:when>

				<xsl:otherwise><input class='watchName' value='{@name}'/></xsl:otherwise></xsl:choose>

			</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

		<xsl:with-param name="value">

			<input value="{@value}"><xsl:attribute name='class'>variableValue<xsl:if test='@changed = "true"'> variableChanged</xsl:if></xsl:attribute><xsl:if test='@editable=false'><xsl:attribute name='readonly'/></xsl:if></input>

		</xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@type)"/>

		</xsl:call-template>

	</xsl:template>

</xsl:stylesheet>

